<?php

namespace Mtc\Notifications\Providers;

use Illuminate\Foundation\Support\Providers\RouteServiceProvider;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\Route;
use Mtc\Notifications\Contracts\NotificationModel;
use Mtc\Notifications\NotificationRepository;

class NotificationProvider extends RouteServiceProvider
{

    public function boot()
    {
        $this->loadViewsFrom(__DIR__ . '/../../resources/views/', 'notifications');

        // Bind model
        $this->app->bind(NotificationModel::class, Config::get('notifications.notification_model'));

        // Bind Notification Facade
        $this->app->bind('notification_repository', function () {
            return new NotificationRepository($this->app->make(NotificationModel::class));
        });
    }

    public function register()
    {
        $this->mergeConfigFrom(dirname(__DIR__, 2) . '/config/notifications.php', 'notifications');
        $this->loadMigrationsFrom(__DIR__ . '/../../database/migrations/');

        parent::register();
    }

    public function map()
    {
        Route::middleware('api')->group(dirname(__DIR__, 2) . '/routes/api.php');
    }
}
