<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateNotificationTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('notifications', function (Blueprint $table) {
            $table->increments('id');
            $table->string('recipient_permission_level')->nullable()->index();
            $table->string('severity')->index();
            $table->string('message');
            $table->text('details')->nullable();
            $table->string('source')->nullable()->index();
            $table->dateTime('read_at')->nullable()->index();
            $table->unsignedBigInteger('read_by')->nullable()->index();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('notifications');
    }
}
