# Notification Centre

This package adds widgets for user alerts. Intended to use in admin area to 
alert about indirect actions like queue task failures, customer queries etc.

System allows adding notifications from code.
Admin users can view, mark read/unread and remvoe notifications.

## Installation

#### Dependencies

```shell script
composer require mtcmedia/notifications ^1.0

# then 
php artisan vendor:publish 
```
and choose option NotificationProvider to publish assets 

 [XX] Provider: Mtc\Notifications\Providers\NotificationProvider
 
#### Adding to site

Following widget needs to be added to site. Preferably in the top navigation bar besides Dashboard link.
```
<notification-widget></notification-widget>
```
 
#### Ensure npm has compiled


## Usage

Widget should appear in menu. Triggering it will allow opening the notification centre link to view the full list.

### Adding notifications

```php
use Mtc\Notifications\Facades\Notification;

// $severity = one of values in [ 'info', 'warning', 'error', 'critical'];
// $message = 'text message explaining notification',
// $context_details = 'Larger piece of information to show info in details'
// $required_permission = optional permission identifier that specifies which users will be able to see this alert - uses permissions table
// $open_url = link that will open if notification is opened

Notification::addNotification($severity, $message, $context_details, $required_permission, $open_url);
  
``` 



 