<?php

namespace Mtc\Notifications\Tests;

use Illuminate\Contracts\Auth\Authenticatable;
use Mtc\Notifications\Providers\NotificationProvider;
use Orchestra\Testbench\TestCase as Orchestra;

class TestCase extends Orchestra
{
    protected function getPackageProviders($app)
    {
        return [
            NotificationProvider::class
        ];
    }

    protected function getEnvironmentSetUp($app)
    {
        app()->bind(Authenticatable::class, User::class);
        $app['config']->set('database.default', 'testbench');
        $app['config']->set('database.connections.testbench', [
            'driver'   => 'sqlite',
            'database' => ':memory:',
            'prefix'   => '',
        ]);

        app('config')->set('tests.notification-permissions', [
            ['name' => 'lorem'],
            ['name' => 'ipsum'],
            ['name' => 'dolor'],
        ]);
    }
}
