<?php

namespace Mtc\PayOnCollection\Providers;

use Illuminate\Support\ServiceProvider;
use Mtc\PayOnCollection\PayOnCollection;

/**
 * Class StripeServiceProvider
 *
 * @package Mtc\PayOnCollection
 */
class PayOnCollectionServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap the application services.
     */
    public function boot()
    {
        if (config('pay_on_collection.enabled', false) === false) {
            return;
        }

        $this->loadTranslationsFrom(dirname(__DIR__, 2) . '/resources/lang', 'pay_on_collection');
        $this->app['payment']->extend('pay-on-collection', function($app) {
            return new PayOnCollection();
        });

        if ($this->app->runningInConsole()) {
            $this->publishes([
                dirname(__DIR__, 2) . '/config/pay_on_collection.php' => config_path('pay_on_collection.php'),
            ], 'config');

            $this->publishes([
                \dirname(__DIR__, 2) . '/resources/templates' => public_path('templates'),
            ], 'templates');

        } else {
            app('twig_loader')->addPath(dirname(__DIR__, 2) . '/resources/templates');
        }
    }

    /**
     * Register the application services.
     */
    public function register()
    {
        // Automatically apply the package configuration
        $this->mergeConfigFrom(dirname(__DIR__, 2) . '/config/pay_on_collection.php', 'pay_on_collection');

    }

}
