<?php

namespace Mtc\Opayo\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\URL;
use Mtc\Checkout\Contracts\InvoiceRepositoryContract;

class OpayoController
{
    /**
     * Attempt payment
     *
     * @param Request $request
     * @param $invoice_id
     * @param InvoiceRepositoryContract $invoice_repository
     * @return \Illuminate\Contracts\Foundation\Application|\Illuminate\Contracts\View\Factory|\Illuminate\Http\RedirectResponse|\Illuminate\View\View
     */
    public function attempt(Request $request, $invoice_id,  InvoiceRepositoryContract $invoice_repository)
    {
        $invoice_repository->load($invoice_id);

        $result = App::make(Config::get('opayo.payment_class'))->attempt($request, $invoice_repository);

        switch ($result['status']) {
            case 'ok':
                $invoice_repository->savePayment($result);
                return redirect()->to(URL::signedRoute('successful_payment', ['id' => $invoice_id ], null, config('app.env') === 'production'));
            case '3DAuth':

                // Store transaction id temporarily
                $invoice_details = $invoice_repository->getModel()->details ?? [];
                $invoice_details['opayo_transaction_id'] = $result['transactionId'];
                $invoice_repository->getModel()->details = $invoice_details;
                $invoice_repository->getModel()->save();

                $result['invoice_id'] = $invoice_id;
                return view('opayo::opayo_3ds', $result);
            default:
            case 'failed':
                return redirect()->to('/payment/failed');
        }
    }

    /**
     * Notify challenge results
     *
     * @param Request $request
     * @param $invoice_id
     * @param InvoiceRepositoryContract $invoice_repository
     * @return \Illuminate\Http\RedirectResponse
     */
    public function notify(Request $request, $invoice_id,  InvoiceRepositoryContract $invoice_repository)
    {
        $invoice_repository->load($invoice_id);
        $invoice_details = $invoice_repository->getModel()->details ?? [];

        $outcome = App::make(Config::get('opayo.payment_class'))->verify($request, $invoice_details['opayo_transaction_id']);
        if ($outcome === false) {
            return redirect()->to('/payment/failed');
        }

        $invoice_repository->savePayment($outcome);
        return redirect()->to(URL::signedRoute('successful_payment', ['id' => $invoice_id ], null, config('app.env') === 'production'));
    }
}