<?php

namespace Mtc\Opayo\Providers;

use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Event;
use Illuminate\Support\ServiceProvider;
use Mtc\Checkout\Events\AddPaymentGatewayScripts;
use Mtc\Opayo\Listeners\AddOpayoExternalScripts;

class OpayoProvider extends ServiceProvider
{
    /**
     * Register the application services.
     */
    public function register()
    {
        // Automatically apply the package configuration
        $this->mergeConfigFrom(dirname(__DIR__, 2) . '/config/opayo.php', 'opayo');
    }

    /**
     * Bootstrap the application services.
     */
    public function boot()
    {
        $this->loadViewsFrom(dirname(__DIR__, 2) . '/resources/views', 'opayo');
        $this->loadTranslationsFrom(dirname(__DIR__, 2) . '/resources/lang', 'opayo');

        $this->app['payment']->extend('opayo', function ($app) {
            return App::make(Config::get('opayo.payment_class'));
        });

        if ($this->app->runningInConsole()) {
            // Publishing assets.
            $this->publishes([
                dirname(__DIR__, 2) . '/resources/js' => resource_path('js/vendor'),
            ], 'assets');

        }
        Event::listen(AddPaymentGatewayScripts::class, AddOpayoExternalScripts::class);

        Route::middleware('web')->group(dirname(__DIR__, 2) . '/routes/web.php');
    }

}
