<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateOrderShipmentTables extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('order_shipments', function (Blueprint $table) {
            $table->increments('id');
            $table->unsignedInteger('order_id')->index();
            $table->unsignedInteger('service_id')->nullable()->index();
            $table->dateTime('exported_at')->nullable()->index();
            $table->decimal('shipment_value', 10)->nullable();
            $table->string('courier_name')->nullable();
            $table->string('tracking_number')->nullable()->index();
            $table->string('tracking_url')->nullable()->index();
            $table->string('label_format', 10)->nullable();
            $table->text('label')->nullable();
            $table->text('shipment_data')->nullable();
            $table->timestamps();
        });

        Schema::create('order_shipment_items', function (Blueprint $table) {
            $table->increments('id');
            $table->unsignedInteger('shipment_id')->index();
            $table->unsignedInteger('order_item_id')->index();
            $table->integer('quantity');
            $table->decimal('ship_weight', 10, 2)->nullable();
            $table->unsignedInteger('box_id')->nullable();
            $table->timestamps();
        });

        Schema::create('order_shipment_boxes', function (Blueprint $table) {
            $table->increments('id');
            $table->unsignedInteger('shipment_id')->index();
            $table->integer('box_id');
            $table->decimal('weight', 10, 2)->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('order_shipments');
        Schema::dropIfExists('order_shipment_items');
        Schema::dropIfExists('order_shipment_boxes');
    }
}
