<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateOrderTables extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('orders', function (Blueprint $table) {
            $table->increments('id');
            $table->dateTime('paid_at')->nullable()->index();
            $table->string('reference')->nullable()->index();
            $table->unsignedInteger('status_id')->default(0)->index();
            $table->unsignedInteger('invoice_id')->nullable()->index();
            $table->unsignedInteger('basket_id')->nullable()->index();
            $table->unsignedInteger('member_id')->nullable()->index();
            $table->decimal('cost_subtotal', 10)->index()->default(0);
            $table->decimal('cost_total', 10)->index()->default(0);
            $table->decimal('vat_value', 10)->default(0)->index();
            $table->string('type')->nullable()->index();
            $table->string('email')->nullable()->index();
            $table->string('customer_name')->nullable();
            $table->string('contact_number')->nullable();
            $table->string('secondary_phone_number')->nullable();
            $table->boolean('newsletter_signup')->nullable();
            $table->text('message')->nullable();
            $table->text('additional_info')->nullable();
            $table->text('tracking_data')->nullable();
            $table->timestamps();
        });

        Schema::create('order_addresses', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('order_id')->nullable()->index();
            $table->string('type', 20)->index();
            $table->string('title')->nullable();
            $table->string('first_name')->nullable();
            $table->string('last_name')->nullable();
            $table->string('address1')->nullable();
            $table->string('address2')->nullable();
            $table->string('city')->nullable();
            $table->string('county')->nullable();
            $table->string('postcode')->nullable();
            $table->string('country')->nullable();
            $table->string('state')->nullable();
            $table->timestamps();
        });

        Schema::create('order_discounts', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('order_id')->nullable()->index();
            $table->morphs('discount');
            $table->decimal('discount_amount', 10)->default(0);
            $table->string('name')->nullable();
            $table->timestamps();
        });

        Schema::create('order_surcharges', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('order_id')->nullable()->index();
            $table->morphs('surcharge');
            $table->decimal('surcharge_amount', 10)->default(0);
            $table->string('name')->nullable();
            $table->timestamps();
        });

        Schema::create('order_items', function (Blueprint $table) {
            $table->increments('id');
            $table->unsignedInteger('order_id')->nullable()->index();
            $table->morphs('purchasable');
            $table->string('name');
            $table->decimal('unit_price', 10);
            $table->decimal('paid_price', 10);
            $table->string('vat_rate')->nullable()->index();
            $table->unsignedInteger('quantity')->index();
            $table->string('sku')->nullable();
            $table->text('attribute_fields')->nullable();
            $table->text('data')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });

        Schema::create('order_item_lines', function (Blueprint $table) {
            $table->increments('id');
            $table->unsignedInteger('order_item_id')->nullable()->index();
            $table->string('reference')->nullable()->index();
            $table->decimal('unit_price', 10);
            $table->decimal('paid_price', 10);
            $table->string('vat_rate')->nullable()->index();
            $table->string('name');
            $table->text('data')->nullable();
            $table->string('sku')->nullable();
            $table->timestamps();
        });

        Schema::create('order_statuses', function (Blueprint $table) {
            $table->increments('id');
            $table->boolean('active')->index()->default(0);
            $table->string('name');
            $table->string('colour_code')->nullable();
            $table->string('email_template_path')->nullable();
            $table->text('email_subject')->nullable();
            $table->text('email_text')->nullable();
            $table->boolean('send_email_on_status')->index()->default(0);
            $table->boolean('is_failure_status')->index()->default(0);
            $table->timestamps();
        });

        Schema::create('order_history', function (Blueprint $table) {
            $table->increments('id');
            $table->unsignedInteger('order_id')->nullable()->index();
            $table->string('triggered_by')->nullable();
            $table->string('name');
            $table->text('details')->nullable();
            $table->string('level', 20)->index();
            $table->boolean('customer_facing')->nullable()->index();
            $table->timestamps();
        });

        Schema::create('order_integration_history', function (Blueprint $table) {
            $table->increments('id');
            $table->unsignedInteger('order_id')->index();
            $table->string('processor')->index();
            $table->string('reference')->nullable()->index();
            $table->unsignedTinyInteger('attempts')->default(1);
            $table->dateTime('processed_at')->nullable()->index();
            $table->dateTime('failed_at')->nullable()->index();
            $table->timestamps();
        });

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('orders');
        Schema::dropIfExists('order_addresses');
        Schema::dropIfExists('order_coupon');
        Schema::dropIfExists('order_discounts');
        Schema::dropIfExists('order_surcharges');
        Schema::dropIfExists('order_items');
        Schema::dropIfExists('order_item_lines');
        Schema::dropIfExists('order_statuses');
        Schema::dropIfExists('order_history');
        Schema::dropIfExists('order_integration_history');
    }
}
