<?php

namespace Mtc\Orders\Filters;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Http\Request;
use Mtc\Foundation\Contracts\AdminFilter;

/**
 * Class FilterByDateTo
 * 
 * @package Mtc\Orders\Filters
 */
class FilterByDateTo implements AdminFilter
{
    /**
     * Constant for input field name
     */
    const INPUT_FIELD_NAME = 'date_to';

    /**
     * Field definition
     *
     * @return mixed
     */
    public function field()
    {
        return [
            'type' => 'text',
            'name' => self::INPUT_FIELD_NAME,
            'label' => 'Date To',
            'class' => 'datepicker',
            'value' => \request(self::INPUT_FIELD_NAME),
        ];
    }

    /**
     * Handle the filtering of a field
     *
     * @param Request $request
     * @param Builder $query
     * @return Builder
     */
    public function handle(Request $request, Builder $query): Builder
    {
        if (empty($request->input(self::INPUT_FIELD_NAME))) {
            return $query;
        }

        try {
            $date = Carbon::createFromFormat('d/m/Y', $request->input(self::INPUT_FIELD_NAME));

            return $query->where('paid_at', '<=', $date);
        } catch (\Exception $exception) {
            return $query;
        }
    }
}
