<?php

namespace Mtc\Orders\Rules;

use Illuminate\Contracts\Validation\Rule;
use Illuminate\Support\Facades\App;
use Mtc\Orders\Contracts\OrderContract;

/**
 * Class ValidOrderReference
 *
 * @package Mtc\Orders\Rules
 */
class ValidOrderReference implements Rule
{
    /**
     * Determine if the validation rule passes.
     *
     * @param  string  $attribute
     * @param  mixed  $value
     * @return bool
     */
    public function passes($attribute, $value)
    {
        return App::make(OrderContract::class)
            ->newQuery()
            ->where('reference', $value)
            ->exists();
    }

    /**
     * Get the validation error message.
     *
     * @return string
     */
    public function message()
    {
        return 'Order with these details was not found.';
    }
}
