<?php

namespace Mtc\Orders\Seeds;

use Illuminate\Database\Seeder;

class OrderAdminMenuSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $shop_menu = \Mtc\Core\Admin\Menu::query()
            ->where('title', 'Shop')
            ->first();

        if ($shop_menu->id) {
            $shop_sub_menu = self::getShopSubMenu();
            foreach ($shop_sub_menu as $sub_menu) {
                $roles = $sub_menu['roles'] ?? [];
                unset($sub_menu['roles']);
                $child = $shop_menu->children()->create($sub_menu);
                \Mtc\Core\Admin\Menu::grantMenuPermissionToRole($child, $roles);
            }
        }
    }

    /**
     * Get admin menu (shop submenu) data
     *
     * @return array
     */
    protected function getShopSubMenu() : array
    {
        return [
            [
                'title' => 'Orders',
                'path' => '/admin/orders',
                'activePath' => '/admin/orders',
                'constant' => '',
                'order' => 0,
                'roles' => [
                    'Administrator'
                ],
            ],
            [
                'title' => 'Order Statuses',
                'path' => '/admin/order-statuses',
                'activePath' => '/admin/order-statuses',
                'constant' => '',
                'order' => 1,
                'roles' => [
                    'Administrator'
                ],
            ],
        ];
    }
}
