<?php

namespace Mtc\Orders\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Mtc\Orders\Http\Requests\ShipmentBoxRequest;
use Mtc\Orders\ShipmentBox;

/**
 * Class ShipmentBoxController
 *
 * @package Mtc\Orders\Http\Controllers
 */
class ShipmentBoxController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $boxes = ShipmentBox::all();
        $this->page_meta['title'] = 'Manage Shipment Boxes';
        return template('admin/shipments/boxes/index.twig', [
            'boxes' => $boxes,
            'page_meta' => $this->page_meta,
        ]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $this->page_meta['title'] = 'Create Shipment Box';
        return template('admin/shipments/boxes/edit.twig', [
            'page_meta' => $this->page_meta,
        ]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(ShipmentBoxRequest $request, ShipmentBox $shipment_box)
    {
        $shipment_box->fill($request->input());
        $shipment_box->save();
        session()->flash('success', 'Box Created');
        return redirect()->to(route('shipment-boxes.index'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  ShipmentBox  $shipmentBox
     * @return \Illuminate\Http\Response
     */
    public function edit(ShipmentBox $shipment_box)
    {
        $this->page_meta['title'] = 'Create Shipment Box';
        return template('admin/shipments/boxes/edit.twig', [
            'box' => $shipment_box,
            'page_meta' => $this->page_meta,
        ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  ShipmentBox  $shipmentBox
     * @return \Illuminate\Http\Response
     */
    public function update(ShipmentBoxRequest $request, ShipmentBox $shipment_box)
    {
        $shipment_box->fill($request->input());
        $shipment_box->save();
        session()->flash('success', 'Box Updated');
        return redirect()->to(route('shipment-boxes.index'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  ShipmentBox  $shipmentBox
     * @return \Illuminate\Http\Response
     */
    public function destroy(ShipmentBox $shipment_box)
    {
        $shipment_box->delete();
        session()->flash('success', 'Box Updated');
        return redirect()->to(route('shipment-boxes.index'));
    }
}
