<?php

namespace Mtc\Orders\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Mtc\Core\Admin\User;
use Mtc\Orders\Contracts\OrderContract;
use Mtc\Orders\Order;

class BulkOrderStatusChange implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * @var OrderContract
     */
    protected $order_model;

    /**
     * @var array
     */
    protected $orders;

    /**
     * @var string
     */
    protected $status_id;

    /**
     * @var User|null
     */
    protected $admin;

    /**
     * Create a new job instance.
     *
     * @param array $orders
     * @param string $action
     * @return void
     */
    public function __construct(OrderContract $order_model, $orders, $action, $admin = null)
    {
        $this->order_model = $order_model;
        $this->orders = $orders;
        $this->status_id = str_replace('status-', '', $action);
        $this->admin = $admin;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        collect($this->orders)
            ->each(function ($order_id) {
                /** @var Order $order */
                $order = $this->order_model->find($order_id);
                $order->changeStatus($this->status_id, $this->admin);
            });
    }
}
