<?php

namespace Mtc\Orders\Providers;

use Illuminate\Database\Eloquent\Relations\Relation;
use Illuminate\Support\ServiceProvider;
use Mtc\Orders\Console\Commands\InstallOrderManagement;
use Mtc\Orders\Contracts\OrderAmendInvoiceFactoryContract;
use Mtc\Orders\Contracts\ShipmentFactoryContract;
use Mtc\Orders\ManualOrderPayment;
use Mtc\Orders\Contracts\OrderContract;
use Mtc\Orders\Contracts\OrderFactoryContract;
use Mtc\Orders\Contracts\OrderRepositoryContract;

/**
 * Class OrderServiceProvider
 *
 * @package Mtc\Money
 */
class OrderServiceProvider extends ServiceProvider
{
    /**
     * Register the application services.
     */
    public function register()
    {
        // Automatically apply the package configuration
        $this->mergeConfigFrom(\dirname(__DIR__, 2) . '/config/orders.php', 'orders');
        $this->loadMigrationsFrom(dirname(__DIR__, 2) . '/database/migrations');

        $this->app->register(config('orders.events'));
        $this->app->register(config('orders.routing'));

        $this->app->bind(OrderContract::class, function () {
            return $this->app->make(config('orders.order_class'));
        });

        $this->app->singleton(OrderFactoryContract::class, function () {
            return $this->app->make(config('orders.order_factory'));
        });

        $this->app->singleton(OrderRepositoryContract::class, function () {
            return $this->app->make(config('orders.order_repository'));
        });

        $this->app->singleton(ShipmentFactoryContract::class, function () {
            return $this->app->make(config('orders.shipment_factory'));
        });

        $this->app->singleton(OrderAmendInvoiceFactoryContract::class, function () {
            return $this->app->make(config('orders.order_amend_invoice_factory'));
        });

        $this->app->bind('shipment_reference', function ($app, $params) {
            if (config('orders.shipment_reference_builder')) {
                return $this->app->make(config('orders.shipment_reference_builder'))($params['shipment']);
            }

            return $params['shipment']->id;
        });
    }

    /**
     * Bootstrap the application services.
     */
    public function boot()
    {
        $this->loadTranslationsFrom(dirname(__DIR__, 2) . '/resources/lang', 'orders');

        Relation::morphMap([
            'order' => config('orders.order_class')
        ]);

        if (config('orders.admin.manual_orders')) {
            $this->app['payment']->extend('manual-order', function ($app) {
                return new ManualOrderPayment();
            });
        }

        if ($this->app->runningInConsole()) {
            $this->publishes([
                \dirname(__DIR__, 2) . '/config/orders.php' => config_path('orders.php'),
            ], 'config');

            $this->publishes([
                \dirname(__DIR__, 2) . '/resources/css' => public_path('css'),
            ], 'assets');

            // Publishing assets.
            $this->publishes([
                dirname(__DIR__, 2) . '/resources/js' => resource_path('js/vendor'),
            ], 'assets');

            $this->publishes([
                dirname(__DIR__, 2) . '/resources/lang' => resource_path('lang/vendor/orders'),
            ], 'lang');

        } else {
            app('twig_loader')->addPath(dirname(__DIR__, 2) . '/resources/templates');
        }
    }
}
