<?php

use Faker\Generator as Faker;

$factory->define(\Mtc\Orders\Order::class, function (Faker $faker) {

    return [
        'paid_at' => random_int(0, 2) ? \Carbon\Carbon::now()->subDays(random_int(0, 20)) : null,
        'reference' => str_random(20),
        'status_id' => random_int(0, 10),
        'cost_total' => random_int(0, 999999) / 100,
        'vat_rate' => array_rand(config('tax.vat_rates')),
        'email' => $faker->safeEmail,
        'contact_number' => $faker->phoneNumber,
        'secondary_phone_number' => random_int(0, 1) ? $faker->phoneNumber : null,
        'newsletter_signup' => random_int(0, 1),
    ];
});

$factory->define(\Mtc\Orders\Item::class, function (Faker $faker) {
    $unit_price = random_int(0, 99999) / 100;
    return [
        'purchasable_id' => random_int(0, 1),
        'purchasable_type' => str_random(),
        'name' => $faker->colorName,
        'unit_price' => $unit_price,
        'paid_price' => random_int(0, 1) ? $unit_price : $unit_price * 0.7,
        'quantity' => random_int(0, 5),
        'sku' => random_int(0, 1) ? str_random(10) : null,
    ];
});

$factory->define(\Mtc\Orders\Address::class, function (Faker $faker) {
    return [
        'type' => random_int(0, 1) ? \Mtc\Orders\Address::TYPE_SHIPPING : \Mtc\Orders\Address::TYPE_BILLING,
        'first_name' => $faker->firstName,
        'last_name' => $faker->lastName,
        'address1' => $faker->address,
        'address2' => random_int(0, 1) ? $faker->address : null,
        'city' => $faker->city,
        'county' => random_int(0, 1) ? $faker->city : '',
        'postcode' => $faker->postcode,
        'country' => $faker->countryCode,
        'state' => random_int(0, 1) ? $faker->stateAbbr : '',
    ];
});

$factory->define(\Mtc\Orders\Discount::class, function (Faker $faker) {
    return [
        'discount_id' => random_int(0, 1),
        'discount_type' => str_random(),
        'discount_amount' => random_int(0, 20000) / 100,
        'name' => 'Coupon: ' . str_random(),
    ];
});

$factory->define(\Mtc\Orders\Surcharge::class, function (Faker $faker) {
    return [
        'surcharge_id' => random_int(0, 1),
        'surcharge_type' => str_random(),
        'surcharge_amount' => random_int(0, 20000) / 100,
        'name' => str_random()
    ];
});

$factory->define(\Mtc\Orders\History::class, function (Faker $faker) {
    $history_types = [
        'Added a note',
        'Updated Status',
    ];

    return [
        'triggered_by' => random_int(0, 1) ? $faker->name : 'System',
        'name' => $history_types[array_rand($history_types)],
        'details' => $faker->paragraph,
        'level' => array_rand(\Mtc\Orders\History::$levels),
        'customer_facing' => random_int(0, 1),
    ];
});
