<?php

namespace Mtc\Orders\Events;

use Illuminate\Queue\SerializesModels;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Broadcasting\InteractsWithSockets;
use Mtc\Orders\OrderShipment;

/**
 * Class ShipmentSaved
 *
 * @package Mtc\Orders\Events
 */
class ShipmentSaved
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    /**
     * @var OrderShipment
     */
    public $shipment;

    /**
     * Create a new event instance.
     *
     * @return void
     */
    public function __construct(OrderShipment $shipment)
    {
        $this->shipment = $shipment;
    }
}
