<?php

namespace Mtc\Orders\Filters;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Http\Request;
use Mtc\Foundation\Contracts\AdminFilter;
use Mtc\Orders\Status;

/**
 * Class FilterByStatus
 * 
 * @package Mtc\Orders\Filters
 */
class FilterByStatus implements AdminFilter
{
    /**
     * Constant for input field name
     */
    const INPUT_FIELD_NAME = 'status_id';

    /**
     * Field definition
     *
     * @return mixed
     */
    public function field()
    {
        return [
            'type' => 'select',
            'name' => self::INPUT_FIELD_NAME,
            'label' => 'Status',
            'default_option_label' => 'All',
            'values' => Status::query()->where('active', 1)->pluck('name', 'id'),
            'value' => \request(self::INPUT_FIELD_NAME),
        ];
    }

    /**
     * Handle the filtering of a field
     *
     * @param Request $request
     * @param Builder $query
     * @return Builder
     */
    public function handle(Request $request, Builder $query): Builder
    {
        if (empty($request->input(self::INPUT_FIELD_NAME))) {
            return $query;
        }

        return $query->where('status_id', $request->input(self::INPUT_FIELD_NAME));
    }
}
