<?php

namespace Mtc\Orders\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\App;
use Mtc\Orders\Contracts\OrderContract;
use Mtc\Orders\Events\OrderStatusChange;
use Mtc\Orders\Listeners\SendOrderStatusEmail;

/**
 * Class OrderConfirmationController
 *
 * @package Mtc\Orders
 */
class OrderConfirmationController extends Controller
{
    /**
     * Trigger order confirmation email
     *
     * @param $order_id
     * @param OrderContract $order
     * @return \Illuminate\Http\RedirectResponse
     */
    public function __invoke($order_id, OrderContract $order)
    {
        $order = $order->find($order_id);

        // To re-send order confirmation we use the status email handler
        // and inject a fake status change into it.
        App::make(SendOrderStatusEmail::class)
            ->handle(new OrderStatusChange($order, config('orders.statuses.confirmed')));

        $order->history()
            ->create([
                'level' => 'success',
                'name' => 'Order Confirmation re-sent',
                'triggered_by' => $this->admin_user->name
            ]);

        session()->flash('success', 'Order Email Sent');
        return redirect()->back();
    }
}
