<?php

namespace Mtc\Orders\Events;

use Illuminate\Queue\SerializesModels;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Broadcasting\InteractsWithSockets;
use Mtc\Orders\OrderShipment;

/**
 * Class ShipmentCancelled
 *
 * @package App\Events
 */
class ShipmentCancelled
{
    use Dispatchable;
    use InteractsWithSockets;
    use SerializesModels;

    /**
     * Shipment getting cancelled
     *
     * @var OrderShipment
     */
    public $shipment;

    /**
     * Create a new event instance.
     *
     * @return void
     */
    public function __construct(OrderShipment $shipment)
    {
        $this->shipment = $shipment;
    }
}
