<?php

namespace Mtc\Orders\Listeners;

use Mtc\Orders\Contracts\OrderEvent;
use Mtc\Orders\Events\OrderPaid;
use Mtc\Orders\Status;

/**
 * Class SendOrderStatusEmail
 *
 * @package Mtc\Orders
 */
class SendOrderStatusEmail
{
    /**
     * Handle the event.
     *
     * @param OrderPaid $event
     * @return void
     */
    public function handle(OrderEvent $event)
    {
        /** @var Status $status */
        $status = Status::query()
            ->where('send_email_on_status', 1)
            ->find($event->getOrder()->status_id);

        if (!$status) {
            return;
        }

        $subject = str_replace('{{SITE_NAME}}', config('app.name'), $status->email_subject);
        $content = template($status->email_template_path, [
            'order' => $event->getOrder(),
            'order_status_text' => $status->getStatusText($event->getOrder()),
        ]);

        email($event->getOrder()->email, $subject, $content);

        $send_copy_to_admin = config('orders.admin_copy.all_statuses') ||
            (config('orders.admin_copy.confirmed') && $status->id == config('orders.statuses.confirmed'));

        if ($send_copy_to_admin && defined('SHOP_EMAIL') && !empty(SHOP_EMAIL)) {
            $subject .= ' (Copy)';
            email(SHOP_EMAIL, $subject, $content);
        }
    }
}
