<?php

namespace Mtc\Orders\Events;

use Mtc\Basket\Basket;
use Mtc\Orders\Order;

/**
 * Class OrderCreated
 *
 * @package Mtc\Orders\Events
 */
class OrderCreated
{
    /**
     * @var Order
     */
    protected $order;

    /**
     * @var Basket
     */
    protected $basket;

    /**
     * @return Order
     */
    public function getOrder()
    {
        return $this->order;
    }

    /**
     * @return Basket
     */
    public function getBasket()
    {
        return $this->basket;
    }

    /**
     * @param Order $order Order that is loaded
     * @param Basket
     */
    public function __construct(Basket $basket, Order $order)
    {
        $this->order = $order;
        $this->basket = $basket;
    }
}
