<?php

namespace Mtc\Orders\Events;

use Illuminate\Queue\SerializesModels;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Broadcasting\InteractsWithSockets;
use Mtc\Orders\Contracts\OrderContract;
use Mtc\Orders\Contracts\OrderEvent;

/**
 * Class OrderStatusChange
 *
 * @package Mtc\Orders\Events
 */
class OrderStatusChange implements OrderEvent
{
    use Dispatchable;
    use InteractsWithSockets;
    use SerializesModels;

    /**
     * @var OrderContract
     */
    protected $order;

    /**
     * @var int
     */
    protected $status_id;

    /**
     * Create a new event instance.
     *
     * @return void
     */
    public function __construct(OrderContract $order, int $status_id)
    {
        $this->order = $order;
        $this->status_id = $status_id;
    }

    /**
     * @return OrderContract
     */
    public function getOrder()
    {
        return $this->order;
    }

    /**
     * @return int
     */
    public function getStatus()
    {
        return $this->status_id;
    }
}
