<?php

namespace Mtc\Orders\Filters;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Http\Request;
use Mtc\Foundation\Contracts\AdminFilter;
use Mtc\Foundation\Country;

/**
 * Class FilterByManager
 *
 * @package Mtc\Orders\Filters
 */
class FilterByManager implements AdminFilter
{
    /**
     * Constant for input field name
     */
    public const INPUT_FIELD_NAME = 'managing_user_id';

    /**
     * Field definition
     *
     * @return mixed
     */
    public function field()
    {
        if (config('orders.assign_to_admin')) {
            return [
                'type' => 'select',
                'name' => self::INPUT_FIELD_NAME,
                'label' => __('orders::orders.order_manager'),
                'default_option_label' => 'All',
                'value' => \request(self::INPUT_FIELD_NAME),
                'values' => app(config('auth.providers.users.model'))
                    ->role(config('orders.assign_to_admin_role'))
                    ->pluck('name', 'id')
                    ->prepend(__('orders::orders.order_manager_unassigned'), -1),
            ];
        }
    }

    /**
     * Handle the filtering of a field
     *
     * @param Request $request
     * @param Builder $query
     * @return Builder
     */
    public function handle(Request $request, Builder $query): Builder
    {
        if (empty($request->input(self::INPUT_FIELD_NAME))) {
            return $query;
        }

        if ($request->input(self::INPUT_FIELD_NAME) == -1) {
            return $query->whereNull('managing_user_id');
        }

        return $query->where('managing_user_id', $request->input(self::INPUT_FIELD_NAME));
    }
}
