<?php

namespace Mtc\Orders\Filters;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Http\Request;
use Mtc\Foundation\Contracts\AdminFilter;

/**
 * Class FilterByPostalCode
 *
 * @package Mtc\Orders\Filters
 */
class FilterByPostalCode implements AdminFilter
{
    /**
     * Constant for input field name
     */
    public const INPUT_FIELD_NAME = 'postal_code';

    /**
     * Field definition
     *
     * @return mixed
     */
    public function field()
    {
        return [
            'type' => 'text',
            'name' => self::INPUT_FIELD_NAME,
            'label' => 'Postal Code',
            'value' => \request(self::INPUT_FIELD_NAME),
        ];
    }

    /**
     * Handle the filtering of a field
     *
     * @param Request $request
     * @param Builder $query
     * @return Builder
     */
    public function handle(Request $request, Builder $query): Builder
    {
        if (empty($request->input(self::INPUT_FIELD_NAME))) {
            return $query;
        }

        $value = $request->input(self::INPUT_FIELD_NAME);
        return $query->where(function (Builder $query) use ($value) {
            return $query
                ->whereHas('billingAddress', function (Builder $billing_query) use ($value) {
                    return $billing_query->where('postcode', $value);
                })
                ->orWhereHas('shippingAddress', function (Builder $shipping_query) use ($value) {
                    return $shipping_query->where('postcode', $value);
                });
        });
    }
}
