<?php

namespace Mtc\Orders\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;
use Mtc\Orders\Contracts\OrderContract;

/**
 * Class OrderBulkProcessController
 *
 * @package Mtc\Orders
 */
class OrderBulkProcessController extends Controller
{
    /**
     * Trigger order confirmation email
     *
     * @param Request $request
     * @param OrderContract $order
     * @return \Illuminate\Http\RedirectResponse
     */
    public function __invoke(Request $request)
    {
        $event = collect(\event('order_bulk_actions'))
            ->filter(function ($event) use ($request) {
                return $event['value'] === $request->input('action');
            })
            ->first();

        // Event not found
        if (empty($event)) {
            session()->flash('error', 'Failed to complete bulk processing - action not found');
            return redirect()->back();
        }

        // Event has immediate response (e.g. download)
        if (!empty($event['immediate'])) {
            return App::make($event['handler'], [
                'orders' => $request->input('orders', []),
                'action' => $request->input('action'),
                'admin' => $this->admin_user,
            ])->handle();
        }

        // Dispatch event (job expected)
        $this->dispatchNow(App::make($event['handler'], [
            'orders' => $request->input('orders', []),
            'action' => $request->input('action'),
            'admin' => $this->admin_user,
        ]));

        return redirect()->back();
    }
}
