<?php

namespace Mtc\Orders\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Mtc\Orders\Contracts\OrderContract;

/**
 * Class OrderDispatchController
 *
 * @package Mtc\Orders
 */
class OrderDispatchController extends Controller
{
    /**
     * Print Dispatch note
     *
     * @param $order_id
     * @param OrderContract $order
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function __invoke($order_id, OrderContract $order)
    {
        return template(config('orders.despatch_note_template'), [
            'order' => $order->withDetails()->find($order_id),
        ]);
    }
}
