<?php

namespace Mtc\Orders\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Mtc\Orders\Contracts\OrderContract;

/**
 * Class OrderNoteController
 *
 * @package Mtc\Orders
 */
class OrderNoteController extends Controller
{
    /**
     * Add a note to order
     *
     * @param Request $request
     * @param $order_id
     * @param OrderContract $order
     * @return \Illuminate\Http\RedirectResponse
     */
    public function __invoke(Request $request, $order_id, OrderContract $order)
    {
        $this->validate($request, [
            'order_note' => 'required',
        ]);

        $order = $order->find($order_id);
        $order->history()
            ->create([
                'level' => 'success',
                'name' => 'Note Added',
                'details' => $request->input('order_note'),
                'triggered_by' => $this->admin_user->name
            ]);

        return redirect()->back();
    }
}
