<?php

namespace Mtc\Orders\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Mtc\Orders\Http\Requests\OrderShipmentBoxRequest;
use Mtc\Orders\Http\Resources\OrderShipmentBoxResponse;
use Mtc\Orders\OrderShipment;
use Mtc\Orders\OrderShipmentBox;
use Exception;

/**
 * Class OrderShipmentBoxController
 *
 * @package Mtc\Ordersr
 */
class OrderShipmentBoxController extends Controller
{
    /**
     * Store a new box
     *
     * @param OrderShipmentBoxRequest $request
     * @param OrderShipment $shipment
     * @return OrderShipmentBoxResponse
     */
    public function store(OrderShipmentBoxRequest $request, OrderShipment $shipment): OrderShipmentBoxResponse
    {
        $shipment->boxes()->create($request->input());
        return new OrderShipmentBoxResponse($shipment);
    }

    /**
     * Update box data
     *
     * @param OrderShipmentBoxRequest $request
     * @param OrderShipment $shipment
     * @param OrderShipmentBox $shipment_box
     * @return OrderShipmentBoxResponse
     */
    public function update(
        OrderShipmentBoxRequest $request,
        OrderShipment $shipment,
        OrderShipmentBox $shipment_box
    ): OrderShipmentBoxResponse {
        $shipment_box->fill($request->input())->save();
        return new OrderShipmentBoxResponse($shipment);
    }

    /**
     * Remove a box
     *
     * @param OrderShipment $shipment
     * @param OrderShipmentBox $shipment_box
     * @return OrderShipmentBoxResponse
     * @throws Exception
     */
    public function destroy(OrderShipment $shipment, OrderShipmentBox $shipment_box): OrderShipmentBoxResponse
    {
        $shipment_box->delete();
        return new OrderShipmentBoxResponse($shipment);
    }
}
