<?php

namespace Mtc\Orders\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

/**
 * Class ShipmentBoxRequest
 *
 * @package App\Http\Requests
 */
class OrderShipmentBoxRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules(): array
    {
        return [
            'box_id' => 'required|exists:shipment_boxes,id',
            'weight' => 'required|numeric|min:0.01',
        ];
    }

    /**
     * Get custom attributes for validator errors.
     *
     * @return array
     */
    public function attributes(): array
    {
        return [
            'box_id' => 'box',
        ];
    }
}
