<?php

namespace Mtc\Orders\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;
use Mtc\Orders\ShipmentBox;
use Illuminate\Http\Request;

/**
 * Class OrderShipmentBoxResponse
 *
 * @package Mtc\Orders
 */
class OrderShipmentBoxResponse extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  Request  $request
     * @return array
     */
    public function toArray($request): array
    {
        $this->resource->load([
            'items',
            'boxes'
        ]);

        return [
            'shipment' => $this->resource,
            'box_types' => ShipmentBox::all(),
        ];
    }
}
