<?php

namespace Mtc\Orders\Listeners;

use Mtc\Orders\Events\FetchOrderProcessingActions;
use Mtc\Orders\Events\OrderPaid;

/**
 * Class ResendOrderConfirmationEmail
 *
 * @package Mtc\Orders
 */
class EditOrderAction
{
    /**
     * Handle the event.
     *
     * @param OrderPaid $event
     * @return array
     */
    public function handle(FetchOrderProcessingActions $event)
    {
        return [
            'name' => 'Edit Order',
            'action' => route('orders.edit', [$event->getOrder()->id]),
            'method' => 'get'
        ];
    }
}
