<?php

namespace Mtc\Orders;

use Illuminate\Support\Facades\Auth;
use Mtc\Checkout\Contracts\InvoiceRepositoryContract;
use Mtc\Checkout\Contracts\PayableContract;

/**
 * Class ManualOrderPaymentApplicableCheck
 *
 * @package  Mtc\BankTransfer
 */
class ManualOrderPaymentApplicableCheck
{
    /**
     * Check if payment is applicable
     *
     * @param InvoiceRepositoryContract $invoice
     * @param PayableContract $payable
     * @return bool
     */
    public function handle(InvoiceRepositoryContract $invoice, $payable): bool
    {
        return Auth::guest() === false;
    }
}
