<?php

namespace Mtc\Orders;

use Illuminate\Support\Facades\File;
use Mtc\Foundation\Contracts\InstallableComponent;
use Mtc\Orders\Providers\OrderServiceProvider;
use Mtc\Orders\Seeds\OrderSeeder;

/**
 * Class OrderInstaller
 *
 * @package Mtc\Orders
 */
class OrderInstaller implements InstallableComponent
{
    /**
     * Define what needs to be published.
     * This should be formatted in following format:
     *
     * @return array
     */
    public function publish(): array
    {
        return [
            [
                '--provider' => OrderServiceProvider::class,
                '--tag' => 'assets'
            ]
        ];
    }

    /**
     * Provide a classname of seeder that should be called
     * In case of no seed required provide an empty string
     */
    public function seed(): string
    {
        return OrderSeeder::class;
    }

    /**
     * List of npm packages and their version restrictions
     *
     * @return array
     */
    public function npmDependencies(): array
    {
        $package_json = json_decode(File::get(dirname(__DIR__) . '/package.json'), true);
        return $package_json['dependencies'] ?? [];
    }

    /**
     * Whether npm should be run to compile assets after installation has been done
     *
     * @return bool
     */
    public function shouldRunNpm(): bool
    {
        return true;
    }
}
