<?php

namespace Mtc\Orders;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * Class OrderShipmentItem
 *
 * @package Mtc\Orders
 */
class OrderShipmentItem extends Model
{
    use SoftDeletes;

    /**
     * Mass assignable attributes
     *
     * @var array
     */
    protected $fillable = [
        'order_item_id',
        'shipment_id',
        'quantity',
        'ship_weight',
        'box_id'
    ];

    /**
     * Relationship with Shipment
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function shipment()
    {
        return $this->belongsTo(OrderShipment::class);
    }

    /**
     * Relationship with order item
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function orderItem()
    {
        return $this->belongsTo(Item::class);
    }

    /**
     * Box this item is in
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function box()
    {
        return $this->belongsTo(OrderShipmentBox::class, 'box_id');
    }

    /**
     * Make sure we are selecting items from completed shipments
     *
     * @param Builder $query
     * @return Builder
     */
    public function scopeCompleted(Builder $query)
    {
        return $query
            ->whereHas('shipment', function ($shipment_query) {
                return $shipment_query->where('status', OrderShipment::STATUS_COMPLETED);
            });
    }
}
