<?php

namespace Mtc\Orders\Seeds;

use Illuminate\Database\Seeder;

class DemoOrderSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     * @throws Exception
     */
    public function run()
    {
        if (!$this->command->confirm('Do you want to seed Demo Orders?')) {
            return;
        }

        $order_count = random_int(10, 1000);
        $this->command->info("Seeding {$order_count} orders");
        $progress_bar = $this->command->getOutput()->createProgressBar($order_count);
        $progress_bar->start();

        factory(\Mtc\Orders\Order::class, $order_count)
            ->create()
            ->each(function (\Mtc\Orders\Order $order, $key) use ($progress_bar) {
                $progress_bar->advance();
                $order->addresses()->save(factory(\Mtc\Orders\Address::class)->make(['type' => 'billing']));
                $order->addresses()->save(factory(\Mtc\Orders\Address::class)->make(['type' => 'shipping']));

                $item_count = random_int(0, 10);
                for ($i = 0; $i < $item_count; $i++) {
                    $order->items()->save(factory(\Mtc\Orders\Item::class)->make());
                }

                $item_count = random_int(0, 2);
                for ($i = 0; $i < $item_count; $i++) {
                    $order->discounts()->save(factory(\Mtc\Orders\Discount::class)->make());
                }

                $item_count = random_int(0, 2);
                for ($i = 0; $i < $item_count; $i++) {
                    $order->surcharges()->save(factory(\Mtc\Orders\Surcharge::class)->make());
                }

                $item_count = random_int(0, 2);
                for ($i = 0; $i < $item_count; $i++) {
                    $order->history()->save(factory(\Mtc\Orders\History::class)->make());
                }
            });
        $progress_bar->finish();
    }
}
