<?php

namespace Mtc\Orders\Contracts;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Http\Request;

/**
 * This interface defines the necessary methods for building a Basket
 *
 * @package Mtc\Basket
 * @author Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
interface OrderContract
{
    /**
     * Get the addresses associated with this basket.
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function addresses();

    /**
     * Check if order has delivery
     *
     * @return bool
     */
    public function hasDelivery(): bool;

    /**
     * Get the relationship to delivery information
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function deliverySurcharge();

    /**
     * Get the addresses associated with this basket.
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function shippingAddress();

    /**
     * Get the list of items within the basket.
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function items();

    /**
     * Get the list of items within the basket.
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function invoices();

    /**
     * Get the list of discounts within the basket.
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function discounts();

    /**
     * Get the list of discounts within the basket.
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function surcharges();

    /**
     * Get the user this belongs to.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function member();

    /**
     * Get the basket this belongs to.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function basket();

    /**
     * Get the current order status.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function status();

    /**
     * Ability to search orders
     *
     * @param Request $request
     * @return mixed
     */
    public function scopeSearch(Builder $query, Request $request);
}
