<?php

namespace Mtc\Paypal\Contracts;

use Mtc\Basket\Contracts\BasketRepositoryInterface;
use PayPal\Api\PayerInfo;

/**
 * Interface PayPalBasketFillInterface
 *
 * @package Mtc\Paypal
 */
interface PayPalBasketFillInterface
{
    /**
     * Update basket from paypal details
     *
     * @param BasketRepositoryInterface $basket
     * @param PayerInfo $details
     * @return mixed
     */
    public function fill(BasketRepositoryInterface $basket, PayerInfo $details);
}
