<?php

namespace Mtc\Paypal;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;
use Mtc\Basket\Contracts\BasketRepositoryInterface;
use Mtc\Checkout\Contracts\ExternalPaymentGateway;
use Mtc\Checkout\Contracts\InvoiceRepositoryContract;
use Mtc\Checkout\PaymentForm;

/**
 * PayPal Payment Gateway
 *
 * @package  Mtc\Paypal
 * @author   Martins Fridenbergs <martins.fridenbergs@mtcmedia.co.uk>
 */
class PayPal implements ExternalPaymentGateway
{
    /**
     * Check if the gateway is available for use on this payment.
     *
     * @param BasketRepositoryInterface $basket
     * @return bool
     */
    public function isApplicable(BasketRepositoryInterface $basket): bool
    {
        return App::make(config('paypal.applicable_check_class'))->handle($basket);
    }

    /**
     * Render the payment template.
     *
     * @param BasketRepositoryInterface $basket
     * @return string
     */
    public function getPaymentForm(BasketRepositoryInterface $basket1): PaymentForm
    {
        return new PaymentForm('');
    }

    /**
     * Charge payment on invoice
     *
     * @param Request $request
     * @param InvoiceRepositoryContract $invoice
     * @return bool
     * @throws \Exception
     */
    public function charge(Request $request, InvoiceRepositoryContract $invoice): array
    {
        /** @var PayPalService $service */
        $service = App::make(PayPalService::class);
        return $service->charge($request, $invoice);
    }

}
