<?php

namespace Mtc\Paypal\Console\Commands;

use Illuminate\Console\Command;
use Mtc\Paypal\Providers\PaypalServiceProvider;

/**
 * Class PayPalInstall
 *
 * Install paypal package
 *
 * @package Mtc\Paypal\Console\Commands
 */
class PayPalInstall extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'paypal:install';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Install paypal required assets';

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        $this->callSilent('vendor:publish', [
            '--provider' => PaypalServiceProvider::class,
            '--tag' => 'assets',
        ]);

        $this->callSilent('vendor:publish', [
            '--provider' => PaypalServiceProvider::class,
            '--tag' => 'config',
        ]);
    }
}
