<?php

namespace Mtc\Paypal\Contracts;

use Mtc\Basket\Contracts\BasketRepositoryInterface;
use Mtc\Checkout\Contracts\InvoiceRepositoryContract;
use PayPal\Api\Payment;
use PayPal\Api\PaymentExecution;
use PayPal\Rest\ApiContext;

/**
 * Interface PayPalPaymentFactoryInterface
 *
 * @package Mtc\Paypal
 */
interface PayPalPaymentFactoryInterface
{
    /**
     * Create paypal payment object from basket
     *
     * @param BasketRepositoryInterface $basket
     * @return Payment
     */
    public function create(BasketRepositoryInterface $basket): Payment;

    /**
     * Set payment reference
     *
     * @param string $reference
     * @param double $amount
     * @return Payment
     */
    public function createPaymentReference(string $reference, $amount);

    /**
     * Update PayPal Payment
     *
     * @param InvoiceRepositoryContract $invoice
     * @return Payment
     */
    public function updateTotals(InvoiceRepositoryContract $invoice, Payment $payment);

    /**
     * Charge payment
     *
     * @param Payment $payment
     * @param PaymentExecution $execution
     * @param ApiContext $context
     * @return mixed
     */
    public function chargePayment(Payment $payment, PaymentExecution $execution, ApiContext $context): array;

}
