<?php

namespace Mtc\Paypal;

use Mtc\Basket\Contracts\BasketRepositoryInterface;
use Mtc\Paypal\Contracts\PayPalBasketFillInterface;
use PayPal\Api\PayerInfo;

/**
 * Class PayPalBasketFillFactory
 *
 * @package Mtc\Paypal
 */
class PayPalBasketFillFactory implements PayPalBasketFillInterface
{
    /**
     * Update basket from paypal details
     *
     * @param BasketRepositoryInterface $basket
     * @param PayerInfo $details
     * @return BasketRepositoryInterface
     */
    public function fill(BasketRepositoryInterface $basket, PayerInfo $details)
    {
        $basket->setAddress('shipping', [
            'first_name' => $details->getFirstName(),
            'last_name' => $details->getLastName(),
            'address1' => $details->getShippingAddress()->line1,
            'address2' => $details->getShippingAddress()->line2 ?? '',
            'city' => $details->getShippingAddress()->city,
            'state' => strtoupper($details->getShippingAddress()->state) ?? '',
            'country' => strtoupper($details->getShippingAddress()->getCountryCode()),
            'postcode' => $details->getShippingAddress()->postal_code
        ]);

        $basket->setDetails( [
            'email' => $details->getEmail(),
            'contact_number' => !empty($details->getPhone()) ? $details->getPhone() : '',
            'newsletter_signup' => 0,
        ]);
        
        return $basket;
    }
}
