<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Enabled functionality
    |--------------------------------------------------------------------------
    |
    | Quickly enable/disable payment gateway
    |
    */

    'enabled' => true,

    /*
    |--------------------------------------------------------------------------
    | Payment Gateway keys
    |--------------------------------------------------------------------------
    |
    | Please set site specific keys in .env file
    | Production keys should never be part of tracked repo
    |
    */

    'live' => env('PAYPAL_EC_LIVE', false),
    'client_id' => env('PAYPAL_EC_CLIENT_ID', ''),
    'client_secret' => env('PAYPAL_EC_CLIENT_SECRET', ''),

    /*
    |--------------------------------------------------------------------------
    | Applicable check
    |--------------------------------------------------------------------------
    |
    | Class that will verify if PayPal EC is applicable to current basket.
    | Change this class to set up conditions when PayPal can/cannot be used for
    | creating a payment
    |
    */

    'applicable_check_class' => \Mtc\Paypal\PayPalApplicableCheck::class,

    /*
    |--------------------------------------------------------------------------
    | Payment Factory
    |--------------------------------------------------------------------------
    |
    | Class that creates and handles a payment from the given basket information.
    | Change this class to modify the information that will be passed to PayPal
    | or the way how charging is handled.
    |
    */

    'payment_factory' => \Mtc\Paypal\PayPalPaymentFactory::class,

    /*
    |--------------------------------------------------------------------------
    | Basket fill factory
    |--------------------------------------------------------------------------
    |
    | Class that will be used to fill basket from PayPal.
    | This class maps PayPal response to basket and should be changed for
    | customized mapping.
    |
    */

    'basket_fill_factory' => \Mtc\Paypal\PayPalBasketFillFactory::class,

    /*
    |--------------------------------------------------------------------------
    | Controller response rendering
    |--------------------------------------------------------------------------
    |
    | This class handles the returned response for controller.
    | Changing this will allow customizing authorize page to add additional data
    | or changing the template if necessary.
    |
    */

    'controller_response_class' => \Mtc\Paypal\Http\Resources\PayPalTemplateResponses::class,

    /*
    |--------------------------------------------------------------------------
    | Template path
    |--------------------------------------------------------------------------
    |
    | Template for button that will be shown on specific pages
    |
    */

    'button_template' => 'paypal_express/form.twig',
];
