<div class="card card-body mt-4">
    <h3>UI Customization</h3>
    <p>Customize how Buttons appear on the site</p>

    <form action="{{ route('admin.paypal.save-customization') }}" method="post">

        <div class="d-flex">
            <div class="col-lg-6">

                <div class="form-group">
                    <div class="form-group">
                        <label for="colour">
                            Colour
                        </label>

                        <select name="colour"
                                id="colour"
                                class="form-control">
                            <option value="gold" {{ $config->get('button_colour') === 'gold' ? 'selected' : '' }}>
                                Gold (recommended)
                            </option>
                            <option value="blue" {{ $config->get('button_colour') === 'blue' ? 'selected' : '' }}>
                                Blue
                            </option>
                            <option value="silver" {{ $config->get('button_colour') === 'silver' ? 'selected' : '' }}>
                                Silver
                            </option>
                            <option value="white" {{ $config->get('button_colour') === 'white' ? 'selected' : '' }}>
                                White
                            </option>
                            <option value="black" {{ $config->get('button_colour') === 'black' ? 'selected' : '' }}>
                                Black
                            </option>
                        </select>
                    </div>
                </div>
                <div class="form-group">
                    <div class="form-group">
                        <label for="shape">
                            Shape
                        </label>

                        <select name="shape"
                                id="shape"
                                class="form-control">
                            <option value="rect" {{ $config->get('button_shape') === 'rect' ? 'selected' : '' }}>
                                Rectangle (recommended)
                            </option>
                            <option value="pill" {{ $config->get('button_shape') === 'pill' ? 'selected' : '' }}>
                                Pill shaped (rounded off edges)
                            </option>
                        </select>
                    </div>
                </div>

                <div class="form-group">
                    <div class="form-group">
                        <label for="size">
                            Size
                        </label>

                        <select name="size"
                                id="size"
                                class="form-control">
                            <option value="default" {{ $config->get('button_size') === 'default' ? 'selected' : '' }}>
                                Default (automatically adapts to page)
                            </option>
                            <option value="25"{{ $config->get('button_size') == 25 ? 'selected' : '' }}>
                                25
                            </option>
                            <option value="30"{{ $config->get('button_size') == 30 ? 'selected' : '' }}>
                                30
                            </option>
                            <option value="35"{{ $config->get('button_size') == 35 ? 'selected' : '' }}>
                                35
                            </option>
                            <option value="40"{{ $config->get('button_size') == 40 ? 'selected' : '' }}>
                                40
                            </option>
                            <option value="45"{{ $config->get('button_size') == 45 ? 'selected' : '' }}>
                                45
                            </option>
                            <option value="50"{{ $config->get('button_size') == 50 ? 'selected' : '' }}>
                                50
                            </option>
                            <option value="55"{{ $config->get('button_size') == 55 ? 'selected' : '' }}>
                                55
                            </option>
                        </select>
                    </div>
                </div>
            </div>
            <div class="col-lg-6">

                <div class="form-group">
                    <div class="form-group">
                        <label for="label">
                            Label
                        </label>

                        <select name="label"
                                id="label"
                                class="form-control">
                            <option value="paypal" {{ $config->get('button_label') === 'paypal' ? 'selected' : '' }}>
                                PayPal Logo (default)
                            </option>
                            <option value="checkout" {{ $config->get('button_label') === 'checkout' ? 'selected' : '' }}>
                                PayPal Checkout
                            </option>
                            <option value="buynow" {{ $config->get('button_label') === 'buynow' ? 'selected' : '' }}>
                                PayPal Buy Now
                            </option>
                            <option value="pay" {{ $config->get('button_label') === 'pay' ? 'selected' : '' }}>
                                Pay with PayPal
                            </option>
                        </select>
                    </div>
                </div>
                <div class="form-group">
                    <div class="form-group">
                        <label for="tagline">
                            Tagline (show a tagline below the payment button)
                        </label>

                        <select name="tagline"
                                id="tagline"
                                class="form-control">
                            <option value="true" {{ $config->get('button_tagline') === 'true' ? 'selected' : '' }}>
                                Enabled
                            </option>
                            <option value="false" {{ $config->get('button_tagline') === 'false' ? 'selected' : '' }}>
                                Disabled
                            </option>
                        </select>
                    </div>
                </div>
            </div>
        </div>
        <button type="submit" class="btn btn-primary">
            Save Customization settings
        </button>
    </form>
</div>