<?php

namespace Mtc\PayPalPayments\Http\Controllers;

use Illuminate\Contracts\Foundation\Application;
use Illuminate\Contracts\Routing\ResponseFactory;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Mtc\Checkout\Invoice;
use Mtc\PayPalPayments\PayPalSettings;

class PayPalWebhookController
{
    /**
     * @param Request $request
     * @param PayPalSettings $settings
     * @return Application|ResponseFactory|Response
     */
    public function webhooks(Request $request, PayPalSettings $settings)
    {
        switch ($request->input('event_type')) {
            case "MERCHANT.ONBOARDING.COMPLETED":
                $this->onboardingCompleted($request->input(), $settings);
                break;
            case "MERCHANT.PARTNER-CONSENT.REVOKED":
                $this->permissionRevoked($request->input(), $settings);
                break;
            case "CHECKOUT.ORDER.APPROVED":
                $this->orderApproved($request->input(), $settings);
                break;
            default:
                break;
        }
        return response('received');
    }

    /**
     * @param array $event_data
     * @param PayPalSettings $settings
     */
    private function onboardingCompleted(array $event_data, PayPalSettings $settings)
    {
        if (!empty($event_data['resource']['merchant_id'])) {
            $settings->save('merchant_id', $event_data['resource']['merchant_id']);
        }
    }

    /**
     * @param array $event_data
     * @param PayPalSettings $settings
     */
    private function permissionRevoked(array $event_data, PayPalSettings $settings)
    {
        $settings->clear();
    }

    /**
     * @param array $event_data
     * @param PayPalSettings $settings
     */
    private function orderApproved(array $event_data, PayPalSettings $settings)
    {
        $order_id = $event_data['resource']['id'];

        $invoice = Invoice::query()
            ->where('outstanding_amount' > 0)
            ->where('details', 'like', '"paypal_order_id":"' . $order_id . '"')
            ->first();

        if ($invoice === null) {
            return;
        }

        $capture = $event_data['resource']['purchase_units'][0]['payments']['captures'][0];

        $invoice->savePayment([
             'provider' => 'PayPal',
             'amount' => $capture['amount']['value'],
             'currency_code' => $capture['amount']['currency_code'],
             'reference' => $capture['id'],
             'details' => $capture,
             'confirmed_at' => now(),
        ]);
    }
}
