<?php

namespace Mtc\PayPalPayments\Listeners;

use Illuminate\Support\Facades\App;
use Mtc\Basket\Contracts\BasketRepositoryInterface;
use Mtc\PayPalPayments\PayPalPayLaterMessages;
use Mtc\PayPalPayments\PayPalSettings;

class AddPayPalMessageContent
{
    /**
     * @var PayPalSettings
     */
    private $settings;


    public function __construct(PayPalSettings $settings)
    {
        $this->settings = $settings;
    }

    /**
     * Add the payment request button to basket
     *
     * @param BasketRepositoryInterface $basket
     */
    public function handle(BasketRepositoryInterface $basket)
    {
        $client_id = $this->settings->get('API_CLIENT_ID');

        if (empty($client_id) || empty($this->settings->get('pay_later_message'))) {
            return null;
        }

        $basket->setExternalGateway(
            'paypal-messages',
            App::make(PayPalPayLaterMessages::class)->getPaymentForm($basket)
        );
    }
}
