<?php

namespace Mtc\PayPalPayments\Listeners;

use Mtc\PayPalPayments\PayPalSettings;
use Mtc\PayPalPayments\Services\PaymentService;

class AddPayPalPaymentIcon
{
    /**
     * @var PayPalSettings
     */
    private $settings;

    public function __construct(PayPalSettings $settings)
    {
        $this->settings = $settings;
    }

    /**
     * Set the delivery name for order when creating it
     *
     * @return string
     */
    public function handle()
    {
        if ($this->settings->readyToTakeCardPayment()) {
            return template('paypal_icon.twig');
        }
        return '';
    }
}
