<?php

namespace Mtc\PayPalPayments\Services;

use Illuminate\Support\Facades\Config;

trait EnvironmentCheckTrait
{
    /**
     * Check the environment that should be used
     *
     * @return bool
     */
    protected function isTestEnvironment(): bool
    {
        return in_array(Config::get('app.env'), ['demo', 'production']) == false
            && Config::get('paypal_payments.use_sandbox') !== true;
    }

    /**
     * Get the environment specific partner ID
     *
     * @return string
     */
    protected function getPartnerId(): string
    {
        return $this->isTestEnvironment()
            ? config('paypal_payments.sandbox_partner_id', '')
            : config('paypal_payments.partner_id', '');
    }
}
