<div class="card card-body mt-4">
    <h3>Pay Later Offers</h3>
    <p>
        PayPal offers short-term, interest-free payments and other special financing options that buyers can use
        to buy now and pay later, while merchants get paid up-front. Pay Later is included with the standard
        PayPal Checkout. However, specific Pay Later offers differ by country.
    </p>
    <p class="mb-1">Pay Later in the UK includes the following:</p>
    <ul class="ml-4 mb-4">
        <li class="mb-1">
            Pay in 3 - Eligible UK buyers can use to pay for purchases of £30 – £2,000 in 3 payments.
            Pay in 3 is interest-free, but late fees apply for missed payments.
        </li>
        <li class="mb-1">
            PayPal Credit - Eligible UK buyers receive a revolving line of credit that they can use to pay over time.
            PayPal Credit offers either 0% interest for 4 months on purchases over £99 or a merchant-specific
            Installment offers. For the 0% interest for 4 months offer, any remaining balance due after
            the promotional period or any transactions under £99 are charged interest at the standard variable rate.
            Terms and conditions apply.
        </li>
    </ul>

    <form action="{{ route('admin.paypal.save-apm') }}" method="post">

        <p>Enabling this method will add encouraging messaging to basket and checkout pages</p>
        <button type="submit"
                name="pay_later"
                class="btn btn-outline-{{ $config->get('pay_later') == 1 ? 'danger' : 'primary' }}"
                value="{{ $config->get('pay_later') == 1 ? '0' : '1' }}">
            {{ $config->get('pay_later') == 1 ? 'Disable' : 'Enable' }}
        </button>
    </form>
</div>