# Paypal Payment Solution

This package offers full user journey for implementing PayPal payments on site.
This includes not only payment taking in checkout but also setting up a merchant 
account in the backend. A section for PayPal Settings is added to Sales admin menu
(/admin/settings/paypal) which allows for clients to go in and link their account.

This package is intended for an up to date mtcmedia/platform installation
and relies on having mtcmedia/core ^1.4.2

## Setup

This payment system will be included with mtcmedia/shop so there should not be 
a requirement to install it manually. However if this is to be attempted, then it
can be done via 
```shell
composer require mtcmedia/paypal-payments

# then 

php artisan install:components
```

When installation is done the payment system needs to be configured.
This is done by running the signup process in admin panel.

For sandbobx use following credentials: https://wiki.mtcmedia.co.uk/index.php?title=Paypal_-_BN_Code#PayPal_Solution

## How it works

Payment system uses a global mtc credential set to allow taking payments and in that 
way removes the requirement for every client to create their own api keys that need to be
added to the site. 

The system uses two APIs. One is the PayPal API for handling all their transactions -
taking payments, issuing refunds and importantly registering a partner to get the merchant_id.
Second API is our internal microservice (paypal.mtcassets.com) that handles global functions like
generating unique tracking ID for linking the account, forwarding webhooks from paypal to relevant site etc.
This system also stores the current active client_id / client_secret for the paypal api and it will be 
retrieved when trying to set up an account.
